<?= $this->include('layout/header_admin') ?>

<div class="container mt-4">

    <h3 class="mb-4">➕ Tambah Riwayat Pendidikan</h3>

    <div class="card shadow-sm">
        <div class="card-body">

            <form action="/auth/pendidikan/store"
                method="post"
                enctype="multipart/form-data">

                <?= csrf_field() ?>

                <!-- Jenjang -->
                <div class="mb-3">
                    <label class="form-label">Jenjang Pendidikan</label>
                    <select name="jenjang" class="form-select" required>
                        <option value="">-- Pilih Jenjang --</option>
                        <option value="SD">SD</option>
                        <option value="SMP">SMP</option>
                        <option value="SMA">SMA</option>
                        <option value="Kuliah">Kuliah</option>
                    </select>
                </div>

                <!-- Nama Sekolah -->
                <div class="mb-3">
                    <label class="form-label">Nama Sekolah / Universitas</label>
                    <input type="text"
                        name="nama_sekolah"
                        class="form-control"
                        placeholder="Contoh: Universitas Yatsi Madani"
                        required>
                </div>

                <!-- Jurusan -->
                <div class="mb-3">
                    <label class="form-label">Jurusan</label>
                    <input type="text"
                        name="jurusan"
                        class="form-control"
                        placeholder="Contoh: Teknik Informatika">
                    <small class="text-muted">
                        (Kosongkan jika SD / SMP)
                    </small>
                </div>

                <!-- Tahun Masuk & Lulus -->
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Tahun Masuk</label>
                        <input type="number"
                            name="tahun_masuk"
                            class="form-control"
                            placeholder="2020">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Tahun Lulus</label>
                        <input type="number"
                            name="tahun_lulus"
                            class="form-control"
                            placeholder="2024">
                    </div>
                </div>

                <!-- Logo Sekolah -->
                <div class="mb-4">
                    <label class="form-label">Logo Sekolah</label>
                    <input type="file"
                        name="logo_sekolah"
                        class="form-control"
                        accept="image/*">
                    <small class="text-muted">
                        Format JPG / PNG • Maks 2MB
                    </small>
                </div>

                <!-- Tombol -->
                <div class="d-flex justify-content-end">
                    <a href="/auth/pendidikan"
                        class="btn btn-secondary me-2">
                        Batal
                    </a>
                    <button type="submit"
                        class="btn btn-success">
                        💾 Simpan
                    </button>
                </div>

            </form>

        </div>
    </div>

</div>

<?= $this->include('layout/footer_admin') ?>